function [mu_hat, sigma2_hat] = NormBiasEst(samples,label)
[d n] = size(samples);

B = 1;
batch_size = floor(n/B);
v = zeros(2*d,B);
for b = 1:B
    batch = samples(:,(batch_size*(b-1)+1):batch_size*b);
    v(:,b) = projSGD(batch, zeros(d,B),label);
end
best_v = v(:,1);
for b = 1:B
    if b == 1
        best_dist = norm(v-repmat(v(:,b),1,B), 'fro');
    else
        dist = norm(v-repmat(v(:,b),1,B), 'fro');
        if dist < best_dist
            best_dist = dist;
            best_v = v(:,b);
        end
    end
end
sigma2_hat = 1./best_v(1:d,1);
mu_hat = best_v(d+1:2*d,1)./best_v(1:d,1);